#include <bits/stdc++.h>
#define int int64_t

using namespace std;

vector<pair<int, int> > points;
vector<pair<int, int> > hull;
vector<pair<int, int> > hull2;


vector<int> indices;
vector<bool> skip;

int cross(pair<int, int> a, pair<int, int> b, pair<int, int> c){
	return (b.first-a.first)*(c.second-a.second)-(b.second-a.second)*(c.first-a.first);
}

int area(vector<pair<int, int>>& setp){
    int last = setp.size() - 1;
    int area = 0;
    for (int i = 0; i < setp.size(); i++)
    {
        area += (setp[last].first + setp[i].first) * (setp[last].second - setp[i].second);
        last = i;
    }
    return abs(area/2);
}

int chull2(){
    int n = points.size();
    hull2.clear();

    for(int i = 0; i < n; i++){
        if(skip[i]) continue;

        while(hull2.size()>1 && cross(hull2[hull2.size()-2], hull2[hull2.size()-1], points[i])<=0){
            hull2.pop_back();
        }
        hull2.push_back(points[i]);
    }
    int len = hull2.size();
    for(int i = n-2; i >= 0; i--){
        if(skip[i]) continue;

        while(hull2.size()>len && cross(hull2[hull2.size()-2], hull2[hull2.size()-1], points[i])<=0 ){
            hull2.pop_back();
        }
        hull2.push_back(points[i]);

    }
    hull2.pop_back();
    return area(hull2);

}

void chull(){


    sort(points.begin(), points.end());
    int n = points.size();

    for(int i = 0; i < n; i++){
        if(skip[i]) continue;

        while(hull.size()>1 && cross(hull[hull.size()-2], hull[hull.size()-1], points[i])<=0){
            hull.pop_back();
        }
        hull.push_back(points[i]);
        indices.push_back(i);
    }
    int len = hull.size();
    for(int i = n-2; i >= 0; i--){
        if(skip[i]) continue;

        while(hull.size()>len && cross(hull[hull.size()-2], hull[hull.size()-1], points[i])<=0 ){
            hull.pop_back();
        }
        hull.push_back(points[i]);
        indices.push_back(i);

    }
    hull.pop_back();
    indices.pop_back();
}

int32_t main()
{
    int n; cin >> n;
    points.reserve(n);
    skip.reserve(n);
    for(int i = 0; i < n; i++){
        int x, y; cin >> x >> y;
        points.push_back({x, y});
        skip.push_back(0);
    }
    chull();
    int res = 1e18+10;
    for(int i = 0; i < hull.size(); i++){
        skip[indices[i]]=1;
        res = min(res, chull2());
        skip[indices[i]]=0;
    }
    cout << res;
    return 0;
}